#include "pch.h"
#include "GpibContec.h"
#include "gpibac.h"
#include "SubFunc.h"

// Constructor
CGpibContec::CGpibContec()
	: m_DeviceAddress(0)
	, m_ReceiveData(_T(""))
	, m_MyAddress(0)
{
}

// Destructor
CGpibContec::~CGpibContec()
{
}

// (1)Connect
BOOL CGpibContec::OpenInterface(DWORD PrimaryAddress)
{
	DWORD Mode;
	DWORD Eoi;
	DWORD Delim;
	CString ErrorMessage;
	DWORD Result;

	Result = static_cast<DWORD>(GpibInit(&ErrorMessage));								// Initialise GPIB
	if (Result != 0) {
		MessageBox(NULL, ErrorMessage, AfxGetAppName(), MB_ICONERROR | MB_OK);
		return FALSE;
	}

	Result = GpBoardsts(0x0a, &Mode);													// Read MASTER or SLAVE
	if (Result != 0) {
		CheckRet(CString(_T("GpBoardsts")), Result, &ErrorMessage);						// Check return value
		MessageBox(NULL, ErrorMessage, AfxGetAppName(), MB_ICONERROR | MB_OK);
		return FALSE;
	}
	if (Mode != 0) {
		MessageBox(NULL, _T("This device is not MASTER. Please check your settings."), AfxGetAppName(), MB_ICONERROR | MB_OK);
		return FALSE;
	}

	Result = GpBoardsts(0x08, &m_MyAddress);											// Get my address
	if (Result != 0) {
		CheckRet(CString(_T("GpBoardsts")), Result, &ErrorMessage);						// Check return value
		MessageBox(NULL, ErrorMessage, AfxGetAppName(), MB_ICONERROR | MB_OK);
		return FALSE;
	}

	Eoi = 1;																			// 0:Not use / 1:Use
	Delim = 3;																			// 0:Unused / 1:CR+LF / 2:CR / 3:LF
	Result = GpDelim(Delim, Eoi); 														// Set delimiter code(EOI)
	if (Result != 0) {
		CheckRet(CString(_T("GpDelim")), Result, &ErrorMessage);						// Check return value
		MessageBox(NULL, ErrorMessage, AfxGetAppName(), MB_ICONERROR | MB_OK);
		return FALSE;
	}

	Result = GpTimeout(1000);															// Set timeout
	if (Result != 0) {
		CheckRet(CString(_T("GpTimeout")), Result, &ErrorMessage); 						// Check return value
		MessageBox(NULL, ErrorMessage, AfxGetAppName(), MB_ICONERROR | MB_OK);
		return FALSE;
	}

	m_DeviceAddress = static_cast<long>(PrimaryAddress);

	return TRUE;
}

// (2)Disconnect
BOOL CGpibContec::CloseInterface()
{
	GpibExit();																			// End of GPIB connection

	return TRUE;
}

// (3)Send commands
BOOL CGpibContec::SendMsg(CString SendData)
{
	long Result;

	Result = GpibPrint(m_DeviceAddress, SendData);										// Write data in the transmit buffer
	if (Result != 0) {
		return FALSE;
	}

	return TRUE;
}

// (4)Receive
BOOL CGpibContec::ReceiveMsg(DWORD Timeout)
{
	CString Buffer;
	CString ErrorMessage;
	long Result;

	Result = GpTimeout(Timeout);														// Set timeout
	if (Result != 0) {
		CheckRet(CString(_T("GpTimeout")), Result, &ErrorMessage); 						// Check return value
		MessageBox(NULL, ErrorMessage, AfxGetAppName(), MB_ICONERROR | MB_OK);
		return FALSE;
	}

	Result = GpibInputHioki(m_DeviceAddress, &Buffer);									// Read data from the receive buffer
	if (Result != 0) {
		m_ReceiveData = _T("Error");
		return FALSE;
	}
	m_ReceiveData = Buffer;																// Save the data

	return TRUE;
}

// (5)Transmit and receive commands
BOOL CGpibContec::SendQueryMsg(CString SendData, DWORD Timeout)
{
	BOOL Result;

	Result = SendMsg(SendData);															// Transmit commands
	if (Result == TRUE) {
		if (SendData.Find(_T("?")) != -1) {
			Result = ReceiveMsg(Timeout);												// Receive response when command transmission is succeeded
		}
	}

	return Result;
}
